local assets =
{
	Asset("ANIM", "anim/pb.zip"),
    Asset("ATLAS", "images/inventoryimages/pb.xml"),
	Asset("ATLAS", "images/inventoryimages/sand.xml"),
	Asset("ATLAS", "images/inventoryimages/sunmine.xml"),
	Asset("ATLAS", "images/inventoryimages/tsilk.xml"),
	Asset("ATLAS", "images/inventoryimages/glass.xml"),
	Asset("ATLAS", "images/inventoryimages/dna.xml"),
	Asset("ATLAS", "images/inventoryimages/tendon.xml"),
}
local function buildgene(tujian)
local function fn()
   local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("seeds")
    inst.AnimState:SetBuild("seeds")
    inst.AnimState:PlayAnimation("idle",true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("inspectable")
--分界线
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = tujian
    inst.components.inventoryitem.atlasname = "images/inventoryimages/"..tujian..".xml"
    inst:AddComponent("selfstacker")
    inst:AddTag("seed")
    MakeHauntableLaunchAndSmash(inst)


    return inst
end
return Prefab(tujian.."info", fn, assets)
end
return
    buildgene("sand"),
	buildgene("sunmine"),
	buildgene("glass"),
	buildgene("tsilk"),
	buildgene("coherer"),
	buildgene("leather"),
	buildgene("garbage"),
	buildgene("tendon"),
    buildgene("dna",true)